c=======================================================================
c23456789012345678901234567890123456789012345678901234567890123456789012
c   Detab , line=72
c   polcorr can be selected in ctrl2
c   line 1 and 180 of histogrm NOT deleted
c   smoothing of inclinations from -3 to 182 (around zenith)
c
       program cip2
c
       implicit none
       include 'cip2.inc'

       print *,'----------------------------------------------------'
       print *,' cip2:  coi/mis/edg  from  azi/inc/mask'
       print *,'        maximum image size is ', n_maxsize
       print *,'        re-written for macosx and g77         apr-04'
       print *,'  >>>   reads square (CLUT) and stereo (POL)'
       print *,' edg2s  sum of difference with 2 neighbours (0-180)'
       print *,' edg4a  2*av of difference with 4 neighbours (0-180)'
       PRINT *,'        last update (polfig correction)     march-07'
       PRINT *,'        last update (edges)                august-07'
       print *,' +MASK  considers mask in misor and edge     june-08'
       print *,'----------------------------------------------------'

       print *,'*calling control'
       call cip01control
       print *,'-------------------------------------------------'

       print *,'*calling readfiles'
       call cip02readfiles
              itot=xdim*ydim
       print *,'*   xdim*ydim=itot ',xdim,ydim,itot
       print *,'-------------------------------------------------'

       if(imisor.eq.1.or.iedge.eq.1) print *,'*calling segment'
       if(imisor.eq.1.or.iedge.eq.1) call cip08segment
       print *,'-------------------------------------------------'

       if(imisor.eq.1.or.iedge.eq.1) print *,'*calling writefiles'
       if(imisor.eq.1.or.iedge.eq.1) call cip09writefiles
       print *,'-------------------------------------------------'

       print *,'*calling polefigure using mask'
       print *,'*   imask =   ', imask,' (0=no,1=yes)' 
       print *,'*   polcorr = ', polcorr,' (option 1-5)'
       
       call cip10polefigure
       print *,'-------------------------------------------------'

       if(iava.eq.1) print *,'*calling ava'
       if(iava.eq.1) call cip11ava
       print *,'-------------------------------------------------'


       call exit
       end


c=======================================================================
c
       subroutine cip01control

c reads azi inc and err files
c
c  fn_result(3) -> mask
c  fn_stereo(2) -> polfig
c

       implicit none
       include 'cip2.inc'

       integer i
       character*80 header
       
c (a)  read from control file

       write(out_unit,'(a)') ' name of controle file : '
       read(in_unit,'(a)') fn_control

       open(unit=ctrl_unit,file=fn_control,
     . status='old',form='formatted')

c--------input file names

       read(ctrl_unit,'(a)') header   ! headers in control file
       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') title

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) xdim,ydim

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) aziref, incref

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) imask

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) imisor,iedge,iava

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,*) polcorr

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_pixclut

c-------input file names  (1=azi, 2=inc, 3=mask)

       read(ctrl_unit,'(a)') header
       do i=1,3
       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_result(i)
       enddo


c-------output file names mono (4=edg2 5=edg4 6=misn 7=mise 8=mish 9=misr)

       read(ctrl_unit,'(a)') header
       do i=4,n_resu
       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_result(i)
       enddo


c-------output file names (coi)

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_ava
       
       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_cpf

       read(ctrl_unit,'(a)') header
       read(ctrl_unit,'(a)') fn_stereo(2)

       close(unit=ctrl_unit)

       return
       end

c===========================================================================
c
       subroutine cip02readfiles


c   reading azi, inc and err files for cip2
c   may 1998

       include 'cip2.inc'

c      read input images

       print *,'*calling readfiles: azi'

       call cip_read_file(fn_result(1),xdim,ydim,pixresult(1,1))

       print *,'*calling readfiles: inc'

       call cip_read_file(fn_result(2),xdim,ydim,pixresult(1,2))

       print *,'*calling readfiles: mask'

       call cip_read_file(fn_result(3),xdim,ydim,pixresult(1,3))

       return
       end


c===========================================================================

       subroutine cip_read_file(filnam,ix,iy,buff)
       
c      opens image file: filnam and reads into linear buffer: buff

       character*(*) filnam
       character*1 buff(1)
       integer ix,iy

       integer iunit
       iunit = 3

       call cip_file_open_r(iunit,filnam)        ! open for read
       call cip_get_file(iunit,ix,iy,buff)
       close(unit=iunit)

       return
       end


c===========================================================================

       subroutine cip_file_open_r(iunit,filnam)
       
c      opens file: filnam for reading


       include 'cip2.inc'
       integer iunit,ilen
       character*(*) filnam
c      parameter 512 = 512
       integer rcl
       common/rectyp/rcl


       call cip_inquire(filnam,rcl)


c        open(unit=iunit,file=filnam,status='old',access='direct',
c     .         form='formatted',recl=xdim)
         open(unit=iunit,file=filnam,status='old',access='direct',
     .   form='unformatted',recl=xdim)



       return
       end


c===========================================================================

       subroutine cip_inquire(filnam,rcl)

       character*(*) filnam

       parameter (idebug = 1)

       character*16 acc
       character*16 blk
       character*16 cc
       character*16 dir
       logical ex
       character*16 fm
       character*16 fmd
       character*16 org
       integer rcl
       character*16 rtype
       character*16 seq
       character*16 unf
       

       inquire(file=filnam,access=acc,direct=dir,exist=ex,
     . form=fm,recl=rcl,unformatted=unf,sequential=seq)

       if(idebug.eq.1) then
          print *,filnam

       if(.not.ex) then
              rcl=-1
              return
       endif

c      print *,'exist        ',ex
c      print *,'access       ',acc
c      print *,'direct       ',dir
c      print *,'sequential   ',seq
c      print *,'form         ',fm
c      print *,'formatted    ',fmd
c      print *,'unformatted  ',unf
c      print *,'recl         ',rcl
c      print *,'recordtype   ',rtype

c      if(dir(1:2).eq.'no') rcl = 0
c      print *,'recl         ',rcl
       endif

       return
       end


c===========================================================================

        subroutine cip_get_file(iunit,ix,iy,buff)

c      reads from unit iunit
c      recl = 512, fixed or ix fixed
c      iunit  : unit number
c      ix,iy  : image dimension
c      buff   : image data

       implicit none
       integer nrec,i,j,ia,ie,ix,iy,iunit
c      integer ib,il

       character*1 buff(1)
       character*(3000) line

       integer rcl
       common/rectyp/rcl


       if(rcl.eq.512) then

c       print *,'rcl.eq.512'

        nrec = ((ix*iy)/rcl)
        if ( mod((ix*iy),rcl) .ne. 0) nrec = nrec+1

        do i = 1,nrec
         ia=(i-1)*512 + 1
         ie=ia+512-1
         read(iunit,rec=i)(buff(j),j=ia,ie)
        enddo

       else

c       print *,'not rcl.eq.512'

        do i=1,iy

c         read(iunit,100,rec=i) line(1:ix)
          read(iunit,rec=i) line(1:ix)
           ia=(i-1)*ix
             do j=1,ix
             buff(ia+j) = line(j:j)
             
c            ib=iachar(buff(ia+j))
c            il=iachar(line(j:j))
c            print *,iy,ix,ib,il

          enddo
        enddo

       endif

  100  format(a)

       return
       end
       
c========================================================================
c
       subroutine cip08segment

c      segments orientation space
c      yield misorientations:
c      magnitude and direction of orientation gradient
c
c      uses and contains sources of cip_edge_mag4 and cip_edge_mag2
c      uses and contains sources of cip_azidip and cip_azidipvec
c      uses cip_angle (source in cip99_utils)

c
c    by default: misn(orth),mise(ast),mish(eaven/hell)
c    choice of one reference direction: mis-aziref-incref
c
       implicit none
       include 'cip2.inc'

       if(iedge.eq.1) call cip_edge_mag2(nr_azi,nr_inc,nr_edge_2)
       if(iedge.eq.1) call cip_edge_mag4(nr_azi,nr_inc,nr_edge_4)   
       if(imisor.eq.1) 
     . call cip_edge_mag(nr_azi,nr_inc,nr_misn,azins,incns)    ! north
       if(imisor.eq.1) 
     . call cip_edge_mag(nr_azi,nr_inc,nr_mise,aziew,incew)    ! east
       if(imisor.eq.1)
     . call cip_edge_mag(nr_azi,nr_inc,nr_mish,azihh,inchh)    ! heaven/hell
       if(imisor.eq.1) 
     . call cip_edge_mag(nr_azi,nr_inc,nr_misr,aziref,incref)  ! ref.dir.

       return
       end


c
c========================================================================
c
       subroutine cip_edge_mag4(na,ni,nr)
*
* for four neighbours           august 2007
* exclude masked points         june 2008
*

c      segments orientation space
c      yields magnitude of orientation gradient
c      na = no.of primary azimuth image
c      ni = no.of primary inclination image
c      nr = no.of result image
c      
c      uses and contains sources of cip_azidip and cip_azidipvec

       implicit none
       include 'cip2.inc'
       integer i,j,ij,azi,inc,azin,incn,na,ni,nr,neib,k
       real p(3), q(3), a, suma

       do i= 2,xdim-1
       do j= 2,ydim-1

c      for each point:
       pixresult(ij(i,j),nr) = char(255)
       neib=0
       suma=0.0

c      center point
       if(imask.eq.1.and.ichar(pixresult(ij(i,j),nr_err)).eq.0)
     .   go to 99
       call cip_azidip(i,j,na,ni,azi,inc)
       call cip_azidipvec(azi,inc,p)

c      first neighbour
         if(imask.eq.1.and.ichar(pixresult(ij(i-1,j),nr_err)).eq.0)
     .   go to 10
       call cip_azidip(i-1,j,na,ni,azin,incn)
       call cip_azidipvec(azin,incn,q)
       call cip_angle(p,q,3,a)
       suma = suma+a
       neib=neib+1

c      second neighbour
10         if(imask.eq.1.and.ichar(pixresult(ij(i+1,j),nr_err)).eq.0)
     .   go to 20
       call cip_azidip(i+1,j,na,ni,azin,incn)
       call cip_azidipvec(azin,incn,q)
       call cip_angle(p,q,3,a)
       suma = suma+a
       neib=neib+1

c      third neighbour
20         if(imask.eq.1.and.ichar(pixresult(ij(i,j+1),nr_err)).eq.0)
     .   go to 30
       call cip_azidip(i,j+1,na,ni,azin,incn)
       call cip_azidipvec(azin,incn,q)
       call cip_angle(p,q,3,a)
       suma = suma+a
       neib=neib+1

c      fourth neighbour
30         if(imask.eq.1.and.ichar(pixresult(ij(i,j-1),nr_err)).eq.0)
     .   go to 40
       call cip_azidip(i,j-1,na,ni,azin,incn)
       call cip_azidipvec(azin,incn,q)
       call cip_angle(p,q,3,a)
       suma = suma+a
       neib=neib+1
       
40       if(neib.eq.0) go to 99
     
       suma=2.*suma/neib               !!!!!!!!!!!!!!!!!!!   twice average
       pixresult(ij(i,j),nr) = char(min(255,int(suma)))

99     continue       

       enddo
       enddo

       return
       end


c
c========================================================================
c
       subroutine cip_edge_mag2(na,ni,nr)

c      segments orientation space
c      yields magnitude of orientation gradient
c      na = no.of primary azimuth image
c      ni = no.of primary inclination image
c      nr = no.of result image
c      
c      uses and contains sources of cip_azidip and cip_azidipvec

       implicit none
       include 'cip2.inc'
       integer i,j,ij,azi,inc,azin,incn,na,ni,nr,neib,k
       real p(3), q(3), a, suma

       do i= 2,xdim-1
       do j= 2,ydim-1

c      for each point:
       pixresult(ij(i,j),nr) = char(255)
       neib=0
       suma=0.0

c      center point

       if(imask.eq.1.and.ichar(pixresult(ij(i,j),nr_err)).eq.0)
     .   go to 99
       call cip_azidip(i,j,na,ni,azi,inc)
       call cip_azidipvec(azi,inc,p)

c      first neighbour
         if(imask.eq.1.and.ichar(pixresult(ij(i+1,j),nr_err)).eq.0)
     .   go to 10
       call cip_azidip(i+1,j,na,ni,azin,incn)
       call cip_azidipvec(azin,incn,q)
       call cip_angle(p,q,3,a)
       suma = suma+a
       neib=neib+1

c      second neighbour
10       if(imask.eq.1.and.ichar(pixresult(ij(i,j+1),nr_err)).eq.0)
     .   go to 20
       call cip_azidip(i,j+1,na,ni,azin,incn)
       call cip_azidipvec(azin,incn,q)
       call cip_angle(p,q,3,a)
       suma = suma+a
       neib=neib+1
       
20       if(neib.eq.0) go to 99
        
       suma=2.*suma/neib               !!!!!!!!!!!!!!!!!!!   twice average
       pixresult(ij(i,j),nr) = char(min(255,int(suma)))

99     continue       

       enddo
       enddo
       

       return
       end


c
c========================================================================
c
       subroutine cip_edge_mag(na,ni,nr,azit,inct)

c      calculates misorientation from transmitted direction (azit,inct)

c      segments orientation space
c      yields rotation with respect to north
c      na = no.of primary azimuth image
c      ni = no.of primary inclination image
c      nr = no.of result image
c      
c      uses and contains sources of cip_azidip and cip_azidipvec
c
c   4.98 azit/inct = transmitted direction

       implicit none
       include 'cip2.inc'
       integer i,j,ij,azi,inc,azin,incn,na,ni,nr,azit,inct
       real p(3), q(3), a

       call cip_azidipvec(azit,inct,q)

       do i= 2,xdim-1
       do j= 2,ydim-1

c      for each point:
       pixresult(ij(i,j),nr) = char(255)

       if(imask.eq.1.and.ichar(pixresult(ij(i,j),nr_err)).eq.0)
     .   go to 99
       call cip_azidip(i,j,na,ni,azi,inc)
       call cip_azidipvec(azi,inc,p)

       call cip_angle(p,q,3,a)

       pixresult(ij(i,j),nr) = char(min(255,int(a)))

99     continue       

       enddo
       enddo

       return
       end


c
c====================================================================
c

       subroutine cip_azidip(i,j,m,n,azi,dip)

c      finds azimuth and inlcination of pixel (i,j) 
c      from two image planes m and n.

       implicit none
       include 'cip2.inc'
       integer i,j,k,m,n,azi,dip,ij

       k   = ij(i,j)

       azi = ichar(pixresult(k,m))
       dip = ichar(pixresult(k,n))

c      if(azi.lt.0. or .azi.gt.180) print *,'azi=',azi
c      if(dip.lt.0. or .dip.gt.180) print *,'dip=',dip

       return
       end

c
c====================================================================
c

       subroutine cip_azidipvec(azi,dip,v)

c      calculates 3-d vector components 
c      for given azimuth (n=0, clockwise) and inclination (zenith=0)

       implicit none
       include 'cip2.inc'
       integer azi,dip
       real v(3),a,d
       
       a=0.01745329*float(azi)
       d=0.01745329*float(dip)

       v(1)=sin(a)*sin(d)
       v(2)=cos(a)*sin(d)
       v(3)=cos(d)

       return
       end


c=======================================================================
c
       subroutine cip09writefiles
c
c      writes the generated image files
c
c      uses cip_write_file (source in cip06_write_files_primary)
c
       implicit none
       include 'cip2.inc'
c
c   writing result files for cip_cycle_2
c   may 1998

       integer i

              if(iedge.eq.1)  print *, fn_result(4)
              if(iedge.eq.1) 
     .      call cip_write_file(fn_result(4),xdim,ydim,pixresult(1,4))

              if(iedge.eq.1)  print *, fn_result(5)
              if(iedge.eq.1) 
     .      call cip_write_file(fn_result(5),xdim,ydim,pixresult(1,5))

              if(imisor.eq.1)  print *, fn_result(6)
              if(imisor.eq.1) 
     .      call cip_write_file(fn_result(6),xdim,ydim,pixresult(1,6))

              if(imisor.eq.1)  print *,  fn_result(7)
              if(imisor.eq.1) 
     .      call cip_write_file(fn_result(7),xdim,ydim,pixresult(1,7))

              if(imisor.eq.1)  print *,  fn_result(8)
              if(imisor.eq.1) 
     .      call cip_write_file(fn_result(8),xdim,ydim,pixresult(1,8))

              if(imisor.eq.1)  print *,  fn_result(9)
              if(imisor.eq.1) 
     .      call cip_write_file(fn_result(9),xdim,ydim,pixresult(1,9))

       return
       end

c=======================================================================

       subroutine cip_write_file(filnam,ix,iy,buff)

       implicit none

       character*(*) filnam
       character*1 buff(1)
       integer ix,iy

       integer iunit
       iunit = 3

       call cip_file_open_w(iunit,filnam,ix)
       call cip_put_file(iunit,ix,iy,buff)
       close(unit=iunit)

       return
       end


c=======================================================================

        subroutine cip_put_file(iunit,ix,iy,buff)

c      write on 'iunit'
c      recordlength recl = ix
c      iunit  : unit number
c      ix,iy  : image dimension
c      buff   : data buffer

       implicit none

       integer nrec,i,j,l,ia,ie,ix,iy,iunit

       character*1 buff(1)
       character*(3000) line

        do i = 1,iy

         ia=(i-1)*ix
cc       ie=ia+ix-1

       do j=1,ix
       line(j:j)=buff(ia+j)
       enddo

c        write(iunit,'(a)',rec=i)(buff(j),j=ia,ie)
c        write(iunit,'(a)',rec=i) line(1:ix)
         write(iunit,rec=i) line(1:ix)
        enddo

       return
       end


c=====================================================================

       subroutine cip_file_open_w(iunit,filnam,width)

       integer iunit,ilen
       character*(*) filnam
       integer width

c      vax convention

c      open(unit=iunit,file=filnam,status='new',access='direct',
c     .       form='formatted',recl=width)
       open(unit=iunit,file=filnam,status='new',access='direct',
     . form='unformatted',recl=width)

       return
       end


c========================================================================
c
       subroutine cip10polefigure
c
c      fills all occurrences of azimuth and dip into image matrix
c      image matrix is n_stereo*n_stereo = 180*180
c      if max occurrence is > 255, pix-matrix is scaled by 255/max
c
c   new: 4.98 (brown): output as in mentex for invpima conversion
c   new: 5.98 brown: masking
c   new: 6.98 brown: slim/combi: offering choices for polefigure correction
c                    1: 1/sin(incl),     2: 1/sin(incl+2.5),  3. 1/sin(inc+5) 
c                    4: 1/sqrt(sin(inc)) 5. 1/sin(incl+1/9(90-inc))
c

c   new 6.99 basel:
c     1: 1/sin(incl),      2: 1/sin(incl-2.5),       3. 1/sin((inc-5)*75/85+10) 
c     4: 1/sqrt(sin(inc))  5. 1/sin(incl+1/9(90-inc))

c
c   new 7.99 basel collect 2-179 only for matrix
c

c   new 3.2007 correct polefigures and smoothing of histogram (xxstereo(180,185))
c
       implicit none
       include 'cip2.inc'
       integer*4 mstereo(n_stereo,n_stereo)
       integer*4 i,j,k,m,n,maxeo,imaxeo,jmaxeo
       integer*4 ixmaxeo,jxmaxeo,ij,ijeo,denseo
       real xstereo(n_stereo,n_stereo)
       real xxstereo(n_stereo,185)    !  185 = n_stereo + 5
       real amaxeo,factor,factor1,factor2,degrad,suma,xmaxeo,xdenseo
       
       real polmatrix(36,36)
       integer intvl,isizepol,isize360,isize90
       intvl = 5                   ! 5*5 stereonet as for mentex/invpima
       isizepol= n_stereo/intvl    ! 180/5 = 36
       isize360= 2*isizepol        !       = 72
       isize90 = isizepol/2        !       = 18
       degrad= 0.01745329

c
c  set real matrix to zero
c

       do i=1,n_stereo  ! parameter (n_stereo = 180, nn_stereo = 180*180)
       do j=1,n_stereo
       xstereo(i,j) = 0.0000
       enddo
       do j=1,n_stereo+5
       xxstereo(i,j) = 0.0000
       enddo
       enddo
       


c============ collect azimuths and inclinations in 180*180 histogram ===========

c   2-d histogram 180*180 i=azi, j=inc
c
c   for mstereo(i,j) and xstereo(i,j)   i=azi, j=inc
c

       if(imask.eq.0) go to 50
       
       do i=1,xdim
       do j=1,ydim
       k=ichar(pixresult(ij(i,j),nr_err))
       if(k.eq.0) go to 49
       m=ichar(pixresult(ij(i,j),nr_azi))
       n=ichar(pixresult(ij(i,j),nr_inc))
       if(m.le.0) go to 49
       if(n.le.0) go to 49
       if(m.gt.180) go to 49
       if(n.gt.180) go to 49
       xstereo(m,n)=xstereo(m,n)+1.0000
49     continue
       enddo
       enddo

       go to 51

c=====if no masking (imask=0)

50     continue
       do i=1,xdim
       do j=1,ydim
       m=ichar(pixresult(ij(i,j),nr_azi))
       n=ichar(pixresult(ij(i,j),nr_inc))
       if(m.le.0) go to 149
       if(n.le.0) go to 149
       if(m.gt.180) go to 149
       if(n.gt.180) go to 149
       xstereo(m,n)=xstereo(m,n)+1.0000
149     continue
       enddo
       enddo

51     continue

c
c====== here make 180*180 histogram image real =================pixmat
c

c
c=============  smooth 1-3 and 178-180  and 89-91 ========= March 2007
c
c
       
       do i=1,n_stereo
       suma = 0.0
       suma = suma + xstereo(i,1) + xstereo(i,2)
     .              + xstereo(i,178) + xstereo(i,179) + xstereo(i,180)
       suma = suma / 5.
       xstereo(i,1) = suma
       xstereo(i,2) = suma
       xstereo(i,178) = suma
       xstereo(i,179) = suma
       xstereo(i,180) = suma

       enddo
       
       
       do i=1,n_stereo
       suma = 0.0
       suma = suma + xstereo(i,89) + xstereo(i,90) + xstereo(i,91)
       suma = suma / 3.
       xstereo(i,89) = suma
       xstereo(i,90) = suma
       xstereo(i,91) = suma

       enddo
       
c
c====== here  make 180*180 histogram image real =================pixmat0
c

c
c================ smooth inclinations ======== 5.3.2007 and 18.3.2007

c                         fixed for 5 degrees (assuming that intvl=5)

       do i=1,n_stereo
       do j=1,n_stereo
       xxstereo(i,j+3)= xstereo(i,j)
       enddo
       xxstereo(i,1)  =xstereo(i,178)
       xxstereo(i,2)  =xstereo(i,179)
       xxstereo(i,3)  =xstereo(i,180)
       xxstereo(i,184)=xstereo(i,1)
       xxstereo(i,185)=xstereo(i,2)
       enddo
       
       do i=1,n_stereo
       do j=1,n_stereo
       
       suma = 0.0
       do k=1,5
       suma = suma + xxstereo(i,j+k)
       enddo
       
       xstereo(i,j) = suma/5.
       
       enddo
       enddo
       

c
c   find maximum of matrix
c
       xmaxeo=0.0000

       do i=1,n_stereo
       do j=1,n_stereo
       xmaxeo= amax1(xstereo(i,j),xmaxeo)

       if(xmaxeo.eq.xstereo(i,j)) then
       ixmaxeo=i
       jxmaxeo=j
       endif

       enddo
       enddo
       
c
c  set matrix to zero again
c

       do i=1,n_stereo  ! parameter (n_stereo = 180, nn_stereo = 180*180)
       do j=1,n_stereo+5
       xxstereo(i,j) = 0.0000
       enddo
       enddo
       


c
c====== here  make 180*180 histogram image real =================pixmat1
c

c
c========== 36*36 histogram images =======================================
c
c   make 36*36 2-d histograms (real and integer)
c

       do j = 1,n_stereo    ! 180
       do i = 1,isizepol    !  36
       do m = 1,intvl       !   5
       n = (i-1)*intvl + m
       xxstereo(i,j) = xxstereo(i,j) + xstereo(n,j)
       enddo
       enddo
       enddo


       do i=1,n_stereo
       do j=1,n_stereo
       xstereo(i,j) = xxstereo(i,j)
       xxstereo(i,j) = 0.0
       enddo
       enddo
       
       
*********** repeat output of pixstereo **************

c====== here  make 180*180 histogram image real =================pixmat2
c
*************************************
       
       

       do j = 1,n_stereo
       do i = 1,isizepol
       do m = 1,intvl
       n = (i-1)*intvl + m
       xxstereo(j,i) = xxstereo(j,i) + xstereo(j,n)
       enddo
       enddo
       enddo
       
       do i=1,n_stereo
       do j=1,n_stereo
       xstereo(i,j) = xxstereo(i,j)
       enddo
       enddo

       
*********** repeat output of pixstereo **************

c====== here  make 180*180 histogram image real =================pixmat3
c
*************************************
c
c   find max of 36*36 matrices
c

c      maxeo=0
       xmaxeo=0.0000
       do i=1,isizepol
       do j=1,isizepol
c      maxeo= max(mstereo(i,j),maxeo)
       xmaxeo= amax1(xstereo(i,j),xmaxeo)
       if(xmaxeo.eq.xstereo(i,j)) then
       ixmaxeo=i
       jxmaxeo=j
       endif
       enddo
       enddo
       

c
c=======================================================
c
c      convert 36*36 integer matrix to image (+ scaling)
c      image size = 180*180 but only upper left corner 36*36 is used.
c      new: use 36 x 36 matrix only - brown, 8.4.1998
c
c=========================== real image scaled  ===========   pixstereo 2(180,180)
c      
       amaxeo = 255./xmaxeo


       do j=1,isizepol
       do i=1,isizepol

       ijeo=(j-1)*n_stereo+i
       xdenseo= amin1(xstereo(i,j)*amaxeo,255.00)
       pixstereo(ijeo,2)=char(ifix(xdenseo))

       enddo
       enddo


c
c========== cpf text files for invpima ===================================
c
c   new: convert from 180*180 to 360*90 matrix for input to invpima
c


       do j=isize90+1,isizepol
       do i=1,isizepol
       
       m=i+isizepol               !azi
       n=isizepol-j+1             !inc

       xstereo(m,n)=xstereo(i,j)
       
       enddo
       enddo

c
c    equalize inc=1-5 and inc=176-180
c    mean of 5 degree interval about inc=0 (image normal) and all azimuths
c
              suma=0.0
              
              do i=1,isize360
              suma=suma+xstereo(i,1)
              enddo

              suma=suma/isize360
              
              do i=1,isize360
              xstereo(i,1)=suma
              enddo

c
c   correct for inclination
c   to "massage" away strong corrections for inc=0-5 and 176-180 degrees
c   1,4  consider upper end of interval
c   2    is center of interval
c   3    corrects from -5 to 95
c   5    effective for reduction of oversampling
c        at low inclinations (wrong stretch of cirpol-> too many 0 incl.s)
c
c     1: 1/sin(incl),      2: 1/sin(incl-2.5),       3. 1/sin((inc-5)*75/85+10) 
c     4: 1/sqrt(sin(inc))  5. 1/sin(incl+1/9(90-inc))
c
       if(polcorr.ne.1) go to 1001
       do j=1,isize90                             ! 1 to 18
       factor= sin(degrad*(float(intvl*j)))       ! 5 to 90
       do i=1,isize360
       xstereo(i,j)= xstereo(i,j)/factor
       enddo
       enddo
1001   if(polcorr.ne.2) go to 1002
       do j=1,isize90
       factor= sin(degrad*(float(intvl*j) - 0.5*float(intvl)))
       do i=1,isize360
       xstereo(i,j)= xstereo(i,j)/factor
       enddo
       enddo
1002   if(polcorr.ne.3) go to 1003
       do j=1,isize90
       factor=sin(degrad*(float(intvl*j-intvl)*75./85.+float(2*intvl)))
       do i=1,isize360
       xstereo(i,j)= xstereo(i,j)/factor
       enddo
       enddo
1003   if(polcorr.ne.4) go to 1004
       do j=1,isize90
       factor= sqrt(sin(degrad*(float(intvl*j))))
       do i=1,isize360
       xstereo(i,j)= xstereo(i,j)/factor
       enddo
       enddo
1004   if(polcorr.ne.5) go to 1005
       do j=1,isize90
       factor= sin(degrad*(float(intvl*j) + float(90-intvl*j)/9.000))
       do i=1,isize360
       xstereo(i,j)= xstereo(i,j)/factor
       enddo
       enddo
1005   continue
c
c   find max of cpf matrix
c
       xmaxeo=0.0
       
       do j=1,isize90
       do i=1,isize360

       xmaxeo= amax1(xstereo(i,j),xmaxeo)
       if(xmaxeo.eq.xstereo(i,j)) then
       ixmaxeo=i
       jxmaxeo=j
       endif
       
       enddo
       enddo


c
c   write cpf integer matrix
c
       factor1= 9999./xmaxeo
       
       do j=1,isize90
       do i=1,isize360
       mstereo(i,j) = ifix(xstereo(i,j)*factor1)
       enddo
       enddo

       open(unit=ctrl_unit,file=fn_cpf,status='new')
       
       write(ctrl_unit,'(a)')  fn_cpf
       write(ctrl_unit,'(a)')  fn_stereo(1)
       write(ctrl_unit,'(a)')  fn_stereo(2)
              
       do j=1,isize90
       write(ctrl_unit,'(18i4)') (mstereo(i,j),i=1,isize360)
       enddo
       close(ctrl_unit)

       call newimacpf(fn_cpf,fn_stereo(2))

       return
       end
       
c=================================================================
       subroutine newimacpf(filnam,filimg)
c
c   inverse approach find poles for each grid point
c   mentex convention azi 0-360    dip 0-90
c
c------input parameters
c
       parameter (nin=18, npac=18, nlin=4)
       parameter (nazi=36, ndip=36)
       parameter (n1020=1020, n10=10)
c
c    nin    block width of input file 18
c    nlin   number of lines per packet nin*nlin=18*4=72 for 360 azi
c    npac   number of packets per block 18 for 90 incl
c    nazi   new width  of block for cpf (180 > azi > 0)
c    ninc   new length of block for cpf (180 > inc > 0)
c    n1020  occupied grid points in stereogrid matrix
c
c------output parameters
c
       parameter (nx=36, ny=36, nx2=40, ny2=40)
c
c
       character*1 pixstereo(36,36)
       character*80 filnam, filimg, filste, filepf, ftemp
       character*80 text1, text2, text3
       character answer
       dimension stereo(nx,ny)
       dimension schmidt(3,nin*nlin,npac)
       character*(nx2) line
       dimension x4n(4),y4n(4)
       dimension iline(nin)
       dimension rotan(2*n10), tiltan(2*n10), tiltax(2*n10)
c
       dimension icpf(nin*nlin,npac)
c                                          72*18  -> 1296
       dimension icpf2(nazi,ndip)
       dimension icpf3(nazi,ndip)
c                                          36*36  -> 1296
c
       data xint,yint,x0,y0/5.,5.,-87.5,-87.5/
       data sin05/.087155/
       data dscrit/0.1/
c
c   x ..,y..   in degrees
c   xs..,ys... in stereonet coordinates
c
       xsint= xint/90.
       ysint= yint/90.
       xs0  = x0/90.
       ys0  = y0/90.
c
       icpfmx=0
       stemax=0.0
c
c   start
c
1      continue
c
c   open file
c
1000   format(a)
1002   format(' ',a)
c
       open(unit=1,file=filnam,status='old')
c
2      continue
       read(1,1000) text1
       read(1,1000) text2
       read(1,1000) text3
c
c   read pole figure as from mentex
c
       do 300 i=1,npac
       do 300 j=1,nlin
       read(1,1001) (iline(k),k=1,nin)
1001   format(18i4)
       do 300 k=1,nin
       l=(j-1)*nin + k
       icpf(l,i)= iline(k)
300    continue
c
c   file names:
c
       filste=filnam
       ml=mlen(filnam)+3
       write(filste(ml-5:ml),'(a)') 'poltxt'
       filepf=filste
       write(filepf(ml-5:ml),'(a)') 'aziepf'
c
c   start find max
c
       do 2001 j=1,npac
       do 2001 i=1,nin*nlin
       icpfmx = max(icpfmx,icpf(i,j))
2001   continue
c
c   write maximum
c
       do 5000 j=1,npac
       do 5000 i=1,nin*nlin
5000   continue
c
c   clean stereonet
c
       call clearm(stereo,nx,ny,0.0)
c
c   start to create stereogrid
c
       do 7000 jloop=1,npac
       do 7000 iloop=1,nin*nlin     !!!trying 0-360/0-90
       azi=-2.5 + iloop*xint
       dip=-2.5 + jloop*yint
       dens= float(icpf(iloop,jloop))
c
c   put pole on x-y plane
c
       call poplups(azi,dip,x,y)
c
c   put into schmidt array
c
       schmidt(1,iloop,jloop)=x
       schmidt(2,iloop,jloop)=y
       schmidt(3,iloop,jloop)=dens
c
c   end of stereogrid loop
c
7000   continue
c
c   take each point on stereogrid and search for poles within 5 deg.conus
c
       do 7500 jgri=1,ny
       do 7500 igri=1,nx
       xg=xs0+(igri-1)*xsint
       yg=ys0+(jgri-1)*ysint
       if(inside(xg,yg,0.,0.,1.).ge.1) go to 7500
       call dircos(xg,yg,cx,cy,cz)
       angsum=0.
       nang=0
       do 7600 jsch=1,npac
       do 7600 isch=1,nin*nlin
       xtemp=schmidt(1,isch,jsch)
       ytemp=schmidt(2,isch,jsch)
       dix=abs(xtemp-xg)
       diy=abs(ytemp-yg)
       if(dix.gt.dscrit.or.diy.gt.dscrit) go to 7600
c
       call dircos(xtemp,ytemp,px,py,pz)
       call angdif(cx,cy,cz,px,py,pz,d)
       if(d.gt.sin05) go to 7600
c
       angsum=angsum+schmidt(3,isch,jsch)
       nang=nang+1
c
7600   continue
c
       if(nang.gt.0) stereo(igri,jgri)=angsum/nang
c
7500   continue
c
c   normalize: multiples of uniform
c
       call unifco(stereo,n1020,nx,ny,stemax)
c
c   open stereonet file for contouring 1-dim: length nx*ny
c
       call baknet(stereo,nx,ny,999.)
c
c   normalize for image representation
c
       do 3001 j=1,ny
       do 3001 i=1,nx
       stereo(i,j)=stereo(i,j)*253.00/stemax+1.
c                                              scale between 1 and 254
3001   continue
c
c   make nice stereonet grid
c
       call baknet(stereo,nx,ny,255.0)
c
c   write into stereonet file
c

       do i=1,36
       do j=1,36
              
       pixstereo(i,j) = char(ifix(stereo(i,j)))
              
       enddo
       enddo
              
       call cip_write_file(filimg,36,36,pixstereo)
       
       end
c
c------------------------------------------------------
c****** functions and subroutines ******
c------------------------------------------------------
c--1
       subroutine clearm(a,nx,ny,val)
c
c   cleans matrix a of size nx,ny
c
       real a(nx,ny)
       do 100 i=1,nx
       do 100 j=1,ny
       a(i,j)=val
100    continue
       return
       end
c------------------------------------------------------
c--1-a
       subroutine baknet(a,nx,ny,back)
c
c   makes background around stereonet matrix
c   assumes zero at center
c
       dimension a(nx,ny)
       xint=2.00/float(nx)
       yint=2.00/float(ny)
       x0= -1.0+0.5*xint
       y0= -1.0+0.5*yint
       do 100 j=1,ny
       do 100 i=1,nx
       x=x0 + (i-1)*xint
       y=y0 + (j-1)*yint
       it= inside(x,y,0.,0.,1.)
       if(it.eq.1) a(i,j)=back
100    continue
       return
       end
c------------------------------------------------------
c--2/1
       subroutine poplups(azi,pinc,xs,ys)
c
c    puts poles on x-y plane, using upper hemisphere projection
c    equal area schmidt net
c
c    azi   in   azimuth 0 = north (=x), running clockwise, from 0 to 180
c    pinc  in   polar angle 0 = up, 90 = x-y plane, 180 = down 
c    x,y   out  x,y coordinates,x increasing right, y increasing up.
c
       data pi/3.141592654/
       data root2/1.414213562/
       data factor/0.0174532925/
       a = azi*factor
       d = pinc*factor
       if(pinc.gt.90.) d=pi-d
c                                   polar angle !
c                                   r=sqrt(2)*sin(pi/4-dip/2)
c                                   in mentex 0 = 90 deg of dip
       r = root2*sin(0.5*d)
       xs = r*sin(a)
       ys = r*cos(a)
       if(pinc.gt.90.) xs = -xs
       if(pinc.gt.90.) ys = -ys
       return
       end
c------------------------------------------------------
c--2/2
       subroutine poplupw(azi,pinc,xs,ys)
c
c    puts poles on x-y plane, using upper hemisphere projection
c    wulff's net
c
c    azi   in   azimuth 0 = north (=x), running clockwise, from 0 to 180
c    pinc  in   polar angle 0 = up, 90 = x-y plane, 180 = down 
c    x,y   out  x,y coordinates,x increasing right, y increasing up.
c
       data pi/3.141592654/
       data root2/1.414213562/
       data factor/0.0174532925/
       a = azi*factor
       d = pinc*factor
       if(pinc.gt.90.) d=pi-d
c                                   polar angle !
c                                   r=tan(pi/4-dip/2)
c                                   in mentex 0 = 90 deg of dip
       r = tan(0.5*d)
       xs = r*sin(a)
       ys = r*cos(a)
       if(pinc.gt.90.) xs = -xs
       if(pinc.gt.90.) ys = -ys
       return
       end
c------------------------------------------------------
c--3
       subroutine dinc(d,pinc,c)
c
c   converts relative densities into relative counts,
c   by multiplying the density and the area on the orientation sphere.
c   only the polar angle pinc is considered.
c
       data factor/0.0174532925/
       f= pinc*factor
       c = d*sin(f)
       return
       end
c------------------------------------------------------
c--4
       subroutine pimesh(x,y,x0,y0,xint,yint,nx,ny,x4n,y4n,ilow,jlow)
c
c   puts points of x-y plane into mesh of a matrix
c   returns 4 neighbouring grid points and indices of lower left corner
c
c   x,y       in   x-y coordinate of point (from -1 to +1)
c   x0,y0     in   x-y value of origin of matrix (-87.5/90.)
c   xint,yint in   x-y intervals between matrix points (5./90.)
c   nx,ny     in   size of matrix
c   x4n,y4n   out  vectors  containing x-y coordinates of neighbours
c   ilow,jlow out  indices of lower left neighbourhood point
c
       integer nx,ny
       dimension x4n(4),y4n(4)
       do 100 k=1,nx+1
       ilow=k
       xcomp=float(k-1)*xint+x0
       if(xcomp.ge.x) go to 101
100    continue
101    continue
       do 200 k=1,ny
       jlow=k
       ycomp=float(k-1)*yint+y0
       if(ycomp.ge.y) go to 201
200    continue
201    continue
       ilow=ilow-1
       jlow=jlow-1
       x4n(1)=xcomp-xint
       x4n(2)=xcomp
       x4n(3)=xcomp
       x4n(4)=xcomp-xint
       y4n(1)=ycomp-yint
       y4n(2)=ycomp-yint
       y4n(3)=ycomp
       y4n(4)=ycomp
       return
       end
c------------------------------------------------------
c--5
       subroutine distri(x,y,c,x4n,y4n,ilow,jlow,s,nx,ny)
c
c   distributes the relative counts of point (x,y) onto the neighbours
c   minimum number of neighbours 1, maximum 4, (icrit=0 -> exit)
c   relative count is split into no.of neighbours and weighted by
c   distance dist of point (x,y) to neighbours (x4n(4),y4n(4)).
c   values are added to matrix s.
c
c   x,y        in  x-y coordinate of point (from poplup)
c   c          in  relative counts of (x,y) (from dinc)
c   x4n,y4n    in  neighbourhood vectors (from pimesh)
c   ilow,jlow  in  indices of lower left neighbourhood point (from pimesh)
c   s      in/out  matrix of grid points
c   nx,ny      in  size of matrix s
c
       dimension s(nx,ny)
       dimension x4n(1),y4n(1)
       dimension is(4), dist(4)
       data is/0,0,0,0/
       data dist/0.,0.,0.,0./
       icrit=0
c
       do 100 k=1,4
       is(k)=inside(x4n(k),y4n(k),0.,0.,1.)
       icrit=icrit+is(k)
c                                                circle at (0,0)
c                                                radius = 1.00
       dist(k)= xydist(x,y,x4n(k),y4n(k))
100    continue
       if(icrit.eq.4) go to 9000
       dsum = 0.0
c
       do 200 k=1,4
       if(is(k).eq.0) dsum = dsum + dist(k)
200    continue
c
       do 300 k=1,4
       dist(k)=dist(k)/dsum
300    continue
c
       if(is(1).eq.0) s(ilow,  jlow)  =s(ilow,  jlow)  +c*dist(1)
       if(is(2).eq.0) s(ilow+1,jlow)  =s(ilow+1,jlow)  +c*dist(2)
       if(is(3).eq.0) s(ilow+1,jlow+1)=s(ilow+1,jlow+1)+c*dist(3)
       if(is(4).eq.0) s(ilow,  jlow+1)=s(ilow,  jlow+1)+c*dist(4)
c
9000   continue
       return
       end
c------------------------------------------------------
c--5-a
       function inside(x,y,xc,yc,r)
c
c   tests if point (x,y) is inside circle at (xc,yc) with radius r
c   returns 0 if inside: radius of point smaller or equal to r
c   returns 1 if outside: radius of point larger than r
c
       inside=0
       xd=x-xc
       yd=y-yc
       rtest = sqrt (xd*xd + yd*yd)
       if(rtest.gt.r) inside=1
       return
       end
c------------------------------------------------------
c--5-b
       function xydist(x1,y1,x2,y2)
c
c   calculates distance between two points (x1,y1) and (x2,y2)
c
       x=x1-x2
       y=y1-y2
       xydist=sqrt(x*x + y*y)
       return
       end
c------------------------------------------------------
c--6
       subroutine makrin(a,nxa,nya,b,nxb,nyb,iring)
c
c   makes a ring around the stereonet.
c   creates matrix b which contains a (= matrix s of stereonet)
c   plus a ring around the stereonet which is used for contouring
c
c   a(nxa,nya) in    matrix with stereonet
c   b(nxb,nyb) out   matrix with stereonet and ring
c   iring      in    width of ring, e.g. iring = 2 -> 
c                                   shift of center (x0,y0) = 2
c                                   nxb,nyb = nxa,nya + 4
c
       dimension a(nxa,nya), b(nxb,nyb)
c      xint=2.00/float(nxa)
c      yint=2.00/float(nya)
c      x0= -0.5*xint
c      y0= -0.5*yint
       xint=5./90.
       yint=5./90.
       x0=-87.5/90.
       y0=-87.5/90.
c
       call clearm(b,nxb,nyb,255.0)
       do 100 j=1,nya
       do 100 i=1,nxa
       i2=i+1
       j2=j+1
       b(i2,j2) = a(i,j)
100    continue
       ri=1.0
       ro=1.1
c      ro=ri+float(2*iring)/float(nxb)
c                                      (2*iring),(nxb) are diameters
       do 200 j=1,nyb
       do 200 i=1,nxb
       call findxy(i,j,x0,y0,xint,yint,x,y)
       itest=inring(x,y,0.,0.,ri,ro)
       if(itest.eq.0) call findop(x,y,0.,0.,1.,xop,yop)
       if(itest.eq.0) call colect(xop,yop,x0,y0,xint,yint,nx,ny,a,fictc)
       b(i,j) = fictc
200    continue
       return
       end
c------------------------------------------------------
c--6-a
       subroutine findxy(i,j,x0,y0,xint,yint,x,y)
c
c   finds x-y values of matrix point
c
c   i,j       in  indices
c   x0,y0     in  x-y values at origin of matrix
c   xint,yint in  x-y intervals between matrix points
c   x,y       out x-y coordinates of matrix point (i,j)
c
       x=x0 + (i-1)*xint
       y=y0 + (j-1)*yint
       return
       end

c------------------------------------------------------
c--6-b
       function inring(x,y,xc,yc,ri,ro)
c
c   tests if point (x,y) is inside ring at (xc,yc)
c   with inner radius ri and outer radius ro
c   returns 0 if within ring:
c   radius of point larger than ri and smaller or equal to ro
c   returns 1 if outside ring:
c   radius of point smaller or equal to ri and larger than ro
c
       inring=0
       rtest = sqrt (x*x + y*y)
       if(rtest.le.ri.or.rtest.gt.ro) inring=1
       return
       end
c------------------------------------------------------
c--6-c
       subroutine findop(x,y,xc,yc,r,xop,yop)
c
c   finds x-y coordinates of pole on opposite side of pole figure
c
c   x,y    in  x-y coordinates of point
c   x0,y0  in  x-y coordinates of centerpoint
c   r      in  radius of stereonet
c   xop,yop out  x-y coordinates of opposing point:
c                pole with pincout = -pincin
c
       xd=x-xc
       yd=y-yc
c                                  rt = radius of (x,y)
c                                  rn = radius of (xop,yop)
       rt=sqrt(xd*xd + yd*yd)
       dr=rt-r
       rn=r-dr
       fac= -rn/rt
       xop= fac*x
       yop= fac*y
       return
       end
c------------------------------------------------------
c--6-d
       subroutine colect(x,y,x0,y0,xint,yint,nx,ny,s,fictc)
c
c   collects from the neighbouring grid points of a point (x,y)
c   the relative counts, and attributes them to (x,y) accoring to the
c   distance of (x,y) from (x4n,y4n).
c   inverse of distri
c
c   x,y        in  x-y coordinate of point (from poplup)
c   x0,y0      in  x-y coordinates of origin of matrix s
c   xint,yint  in  x-y intervals in matrix s
c   nx,ny      in  size of matrix s
c   s          in  matrix of grid points
c   fictc     out
c
c      dimension s(nx,ny)
       dimension s(1,1)
       dimension x4n(4),y4n(4)
       dimension dist(4)
       dimension itest(4)
       fictc=0.0
c
       call pimesh(x,y,x0,y0,xint,yint,nx,ny,x4n,y4n,ilow,jlow)
c
       do 100 k=1,4
       itest(k)=inside(x4n(k),y4n(k),0.,0.,1.)
c                                                circle at (0,0)
c                                                radius = 1.00
       dist(k)= xydist(x,y,x4n(k),y4n(k))
100    continue
c
       dsum = 0.0
       do 200 k=1,4
       if(itest(k).eq.0) dsum = dsum + dist(k)
200    continue
c
       do 300 k=1,4
       dist(k)=dist(k)/dsum
300    continue
c
       if(itest(1).eq.0) fictc = fictc + s(ilow,jlow)*dist(1)
       if(itest(2).eq.0) fictc = fictc + s(ilow+1,jlow)*dist(2)
       if(itest(3).eq.0) fictc = fictc + s(ilow+1,jlow+1)*dist(3)
       if(itest(4).eq.0) fictc = fictc + s(ilow,jlow+1)*dist(4)
c
9000   continue
       return
       end



c------------------------------------------------------
c--7
       subroutine unifco(s,n1020,nx,ny,smax)
c
c   scales values of matrix of stereonet such that they are in
c   mulitples of uniform
c   for origin of stereonet in center of matrix cell
c   the number of occupied points n1020 = 1020.
c   for origin of stereonet on grid point n1020 = 1009.
c
c   the maximum value in matrix s (after normalization) is printed
c   and returned.
c
       dimension s(nx,ny)
       sum = 0.0
       smax= 0.0
       do 100 i=1,nx
       do 100 j=1,ny
       sum = sum + s(i,j)
100    continue
       do 200 i=1,nx
       do 200 j=1,ny
       s(i,j)= (n1020*s(i,j))/sum
       smax=amax1(smax,s(i,j))
200    continue
       do 300 i=1,nx
       do 300 j=1,ny
       if(s(i,j).ge.smax) write(6,500) i,j,s(i,j)
500    format
     . (' --> maximum of polefigure is at (',i2,',',i2,'): ',f12.5)
300    continue
       return
       end
c=================================================
c   rotations
c
c------------------------------------------------------
       subroutine polxyz(azi,dip,x,y,z)
c
c   converts polar representation into x-y-z coordinates
c   takes any range of azi and dip
c   azi clockwise from 0 (=n)(=+x) to 180 (=s)(=-x)
c   dip from 0 (=up)(=+z) to 180 (=down)(=-z)
c
       data pi/3.141592654/
       data factor/0.0174532925/
       p=factor*dip
       z  = cos(p)
       rpl= sin(p)
       a= factor*azi
       x=  cos(a)*rpl
       y= -sin(a)*rpl
c      write(6,100) azi,dip,a,d,x,y,z
c100   format(' inside polxyz: azi,dip,a,d,x,y,z: '/7(f9.4,1x))
       return
       end
c------------------------------------------------------
       subroutine polxyzm(azi,dip,x,y,z)
c
c   mentex adapted
c   converts polar representation into x-y-z coordinates
c   takes any range of azi and dip
c   azi clockwise from 0 (=n)(=+x) to 360 (=n)(=+x)
c   dip from 0 (=up)(=+z) to 90 (=horizontal)(=x-y plane
c
       data pi/3.141592654/
       data factor/0.0174532925/
       p=factor*dip
       a= factor*azi
       z  = cos(p)
       rpl= sin(p)
       x=  cos(a)*rpl
       y= -sin(a)*rpl
c      write(6,100) azi,dip,a,d,x,y,z
c100   format(' inside polxyzm: azi,dip,a,d,x,y,z: '/7(f9.4,1x))
       return
       end
c------------------------------------------------------
       subroutine xyzpol(x,y,z,azi,dip)
c
c   converts x-y-z coordinates into polar representation
c   returns two ranges of azi and dip
c   azi clockwise from 0 (=n)(=+x) to 180 (=s)(=-x)
c   dip from 0 (=up)(=+z) to 180 (=down)(=-z)
c
       data factor/57.29577951/
       data pi,pihalf,twopi/3.141592654,1.5707963,6.2831853/
       d  = acos(z)
       a  = pihalf
        if(x.ne.0.) a = atan(-y/x)
c
       if(x.lt.0.) a = a + pi
c
       azi= factor*a
       dip= factor*d
       if(azi.lt.0.) dip = 180.-dip
       if(azi.lt.0.) azi = azi + 180.
       if(azi.gt.180.) dip = 180. - dip
       if(azi.gt.180.) azi = azi - 180.
c      write(6,100) x,y,z,a,d,azi,dip
c100   format(' inside xyzpol: x,y,z,a,d,azi,dip: '/(7f9.4,1x))
       return
       end
c------------------------------------------------------
       subroutine xyzpolm(x,y,z,azi,dip)
c
c   mentex adapted
c   converts x-y-z coordinates into polar representation
c   returns two ranges of azi and dip
c   azi clockwise from 0 (=n)(=+x) to 360 (=n)(=+x)
c   dip from 0 (=up)(=+z) to 90 (=horizontal)(=x-y plane)
c
       data factor/57.29577951/
       data pi,pihalf,twopi/3.141592654,1.5707963,6.2831853/
       d  = acos(abs(z))
       a  = pihalf
        if(x.ne.0.) a = atan(-y/x)
c
       if(x.lt.0.) a = a + pi
       if(z.lt.0.) a = a + pi
       if(a.lt.0.) a = a + twopi
       if(a.gt.twopi) a = a-twopi
c
       azi= factor*a
       dip= factor*d
c
c      write(6,100) x,y,z,a,d,azi,dip
c100   format(' inside xyzpolm: x,y,z,a,d,azi,dip: '/(7f9.4,1x))
       return
       end
c------------------------------------------------------
       subroutine dircos(xg,yg,cx,cy,cz)
c
c   converts coordinates of schnmidt net to direction cosines
c
       data factor/57.29577951/
       data root2/1.414213562/
       data pi,pihalf,twopi/3.141592654,1.5707963,6.2831853/
c
       r=sqrt(xg*xg+yg*yg)
       d=2.*asin(r/root2)
c      
       a  = pihalf
        if(yg.ne.0.) a = atan(xg/yg)
c
       if(yg.lt.0.) a = a + pi
       if(a.lt.0.) a = a + twopi
c
       cz  = cos(d)
       rpl= sin(d)
       cx=  cos(a)*rpl
       cy= -sin(a)*rpl
c
       return
       end
c------------------------------------------------------
       subroutine angdif(cx,cy,cz,px,py,pz,sin)
c
c   calculates angular difference, from direction cosines
c   returns sine of difference
c
       c=cx*px+cy*py+cz*pz
       sin=sqrt(1.-c*c)
       return
       end
c------------------------------------------------------
       subroutine rotz(x,y,z,a)
c
c   rotates point (px,py,pz) about angle a in x-y plane, about z
c
       data factor/0.0174532925/
       an=a*factor
       cosa=cos(an)
       sina=sin(an)
       xn= cosa*x - sina*y
       yn= sina*x + cosa*y
       x=xn
       y=yn
       return
       end

c------------------------------------------------------
       subroutine rotx(x,y,z,a)
c
c   rotates point (px,py,pz) about angle a in y-z plane, about x
c
       data factor/0.0174532925/
       an=a*factor
       cosa=cos(an)
       sina=sin(an)
       yn= cosa*y - sina*z
       zn= sina*y + cosa*z
       y=yn
       z=zn
       return
       end
c------------------------------------------------------
       subroutine tilt(x,y,z,ax,an)
c
c   tilts point about horizontal tilt axis
c
       call rotz(x,y,z,ax)
c      print *,' tilt/rotz1: x,y,z: ',x,y,z
       call rotx(x,y,z,-an)
c      print *,' tilt/rotx: x,y,z: ',x,y,z
       call rotz(x,y,z,-ax)
c      print *,' tilt/rotz2: x,y,z: ',x,y,z
       return
       end
c
c
c------------------------------------------------------------------
       function mlen(s)
c      determine actual length of string s
c
       character *(*) s
       l=len(s)
       do 10 k=l,1,-1
       lg=k
       if(s(k:k).ne.' ') goto 99
   10  continue
       lg=0
   99  mlen=lg
       return
       end
c

       
c===============================================================

       subroutine cip11ava
c
c      produces ava using the colour lookup table clut
c      uses and contains the source of cip_clut
c      uses cip_write_file (source in cip06_write_files_primary)
c      to write rgb non-interleaved colour image: fn_ava
c


       implicit none
       include 'cip2.inc'

       integer*4 azi,inc,i,j, jj, k

c
c  reads square clut (fn_pixclut:  selfmade.clut)
c

       jj=xdim
       xdim=180
       call cip_read_clut
       xdim=jj

c      do i=1,itot
c      do j=1,3
c      pixava(i+(j-1)*itot) = char(0)
c      enddo
c      enddo

       do i=1,itot

       azi = ichar(pixresult(i,nr_azi))
       inc = ichar(pixresult(i,nr_inc))


c      k=ichar(char(i))
c      print *,'i,k=ichar(char(i)), azi,inc ',i,k,azi,inc
       
       k   = ichar(pixresult(i,nr_err))
       if(imask.eq.1.and.k.eq.0) go to 49

c
c   polamp via cip.inc: common /pol_or_amp/polamp
c
       do j=1,3
       pixava(i+(j-1)*itot) = clut(j,inc,azi)
       enddo
49     continue
       enddo

       call cip_write_file(fn_ava,xdim,3*ydim,pixava)

       return
       end

c===============================================================

       subroutine cip_read_clut
c
c      reads the colour lookup table clut from
c      a 180*180 rgb (non-interleaved) picture file
c      data are in stereo graphic projection (diameter = 180) 
c

       implicit none
       include 'cip2.inc'

       integer*4 j,i,ipix,jpix,ij,jj
       integer*4 stereox,stereoy
       integer len
       integer mlen

       call cip_read_file(fn_pixclut,n_stereo,3*n_stereo,pixclut)

       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       clut(jj,j,i) = pixclut(i + (j-1)*n_stereo + (jj-1)*nn_stereo)
       enddo
       
       enddo
       enddo
       
       
       len = mlen(fn_pixclut)
       
       
       if (fn_pixclut(len-2:len).eq.'pol'.
     . or.fn_pixclut(len-2:len).eq.'POL')
     . call cip_convert_clut    

       if (fn_pixclut(len-2:len).eq.'wulff'.
     . or.fn_pixclut(len-2:len).eq.'WULFF')
     . call cip_convert_clut_w     

       return
       end

c==================================================================
       subroutine cip_convert_clut
c
c    converts pol type clut to clut if name of clut ends with .pol
c

       implicit none
       include 'cip2.inc'
       
       integer*4 j,i,ipix,jpix,ij,jj
       integer*4 lx,ly
       integer*4 azi,inc
       real x,y

       character*1 clut2(3,n_stereo,n_stereo)
       
       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       clut2(jj,j,i) = clut(jj,j,i)
       enddo
       
       enddo
       enddo
       
c                          clut(channel, inc, azi)      
c                          clut(   jj  ,  j ,  i )      
c                          clut(   jj  , ly , lx )      
       
       
       do lx=1,n_stereo   
       do ly=1,n_stereo
       
c===============================================================

       if(ly.le.90) then
       
       x=sin(float(lx)*0.0174532925) * float(ly)
       y=cos(float(lx)*0.0174532925) * float(ly)
       i=90+ifix(x)
       j=90-ifix(y)
       
       else
       
       x=sin(float(lx)*0.0174532925) * float(180-ly)
       y=cos(float(lx)*0.0174532925) * float(180-ly)
       i=90-ifix(x)
       j=90+ifix(y)
       
       endif


c===============================================================

       do jj=1,3
       clut(jj,ly,lx) = clut2(jj,j,i)
       enddo
       
       enddo
       enddo



       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       pixclut(i + (j-1)*n_stereo + (jj-1)*nn_stereo) = clut(jj,j,i)
       enddo
       
       enddo
       enddo
       
       
       call cip_write_file
     . ('convert.clut.raw',n_stereo,3*n_stereo,pixclut)
       
       
       
       return
       end
       


c==================================================================
       subroutine cip_convert_clut_s  ! (DOES NOT WORK)
c
c    converts pol type clut to clut if name of clut ends with .pol
c    schmidt projection
c

       implicit none
       include 'cip2.inc'
       
       integer*4 j,i,ipix,jpix,ij,jj
       integer*4 lx,ly
       integer*4 azi,inc,len,mlen
       real x,y,r,factor,root2
       
       data root2/1.414213562/
       data factor/0.0174532925/

       character*1 clut2(3,n_stereo,n_stereo)
       
       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       clut2(jj,j,i) = clut(jj,j,i)
       enddo
       
       enddo
       enddo
       
c                          clut(channel, inc, azi)      
c                          clut(   jj  ,  j ,  i )      
c                          clut(   jj  , ly , lx )      
       
       
       do lx=1,n_stereo  
       do ly=1,n_stereo
       
c===============================================================

       if(ly.le.90) then
       
       r=90.*root2*sin(0.5*float(ly)*factor)
       
       x=sin(float(lx)*factor) * r
       y=cos(float(lx)*factor) * r
       i=90+ifix(x)
       j=90-ifix(y)
       
       else
       
       r=90.*root2*sin(0.5*float(180-ly)*factor)

       x=sin(float(lx)*factor) * r
       y=cos(float(lx)*factor) * r
       i=90-ifix(x)
       j=90+ifix(y)
       
       endif


c===============================================================

       do jj=1,3
       clut(jj,ly,lx) = clut2(jj,j,i)
       enddo
       
       enddo
       enddo



       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       pixclut(i + (j-1)*n_stereo + (jj-1)*nn_stereo) = clut(jj,j,i)
       enddo
       
       enddo
       enddo
       
       len = mlen(fn_pixclut)+5
       fn_pixclut(len:len)='t'
       len=len-1
       fn_pixclut(len:len)='u'
       len=len-1
       fn_pixclut(len:len)='l'
       len=len-1
       fn_pixclut(len:len)='c'
       len=len-1
       fn_pixclut(len:len)='.'
       
c      call cip_write_file(fn_pixclut,n_stereo,3*n_stereo,pixclut)
       
       
       return
       end
       

c==================================================================
       subroutine cip_convert_clut_w  ! (MAY NOT WORK...??)
c
c    converts pol type clut to clut if name of clut ends with .wul
c    wulff projection
c

       implicit none
       include 'cip2.inc'
       
       integer*4 j,i,ipix,jpix,ij,jj
       integer*4 lx,ly
       integer*4 azi,inc,len,mlen
       real x,y,r,factor,root2
       
       data root2/1.414213562/
       data factor/0.0174532925/

       character*1 clut2(3,n_stereo,n_stereo)
       
       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       clut2(jj,j,i) = clut(jj,j,i)
       enddo
       
       enddo
       enddo
       
c                          clut(channel, inc, azi)      
c                          clut(   jj  ,  j ,  i )      
c                          clut(   jj  , ly , lx )      
       
       
       do lx=1,n_stereo  
       do ly=1,n_stereo
       
c===============================================================

       if(ly.le.90) then
       
       r=90.*tan(0.5*float(ly)*factor)
       
       x=sin(float(lx)*factor) * r
       y=cos(float(lx)*factor) * r
       i=90+ifix(x)
       j=90-ifix(y)
       
       else
       
       r=90.*tan(0.5*float(180-ly)*factor)

       x=sin(float(lx)*factor) * r
       y=cos(float(lx)*factor) * r
       i=90-ifix(x)
       j=90+ifix(y)
       
       endif


c===============================================================

       do jj=1,3
       clut(jj,ly,lx) = clut2(jj,j,i)
       enddo
       
       enddo
       enddo



       do i=1,n_stereo
       do j=1,n_stereo

       do jj=1,3
       pixclut(i + (j-1)*n_stereo + (jj-1)*nn_stereo) = clut(jj,j,i)
       enddo
       
       enddo
       enddo
       
       len = mlen(fn_pixclut)+5
       fn_pixclut(len:len)='t'
       len=len-1
       fn_pixclut(len:len)='u'
       len=len-1
       fn_pixclut(len:len)='l'
       len=len-1
       fn_pixclut(len:len)='c'
       len=len-1
       fn_pixclut(len:len)='.'
       
       call cip_write_file(fn_pixclut,n_stereo,3*n_stereo,pixclut)
              
       
       return
       end
       

c
c======================================================================
c
       subroutine cip_angle(p,q,n,a)

c      uses the acute angle

       dimension p(n),q(n)
       call angle(p,q,n,a)
       if(a.gt.90.00) a = 180. - a
       return
       end
c
c======================================================================
c
       subroutine angle(p,q,n,a)

c   input: vector p and q of dimension n
c   returns angle in degrees
c
       dimension p(n), q(n)
       data factor/57.295779513082/
c                               conversion from radian to degree
       s = scalp(p,q,n)
       t = vecm(p,n)
       r = vecm(q,n)
       arg = s/(t*r)
       if(arg.gt.1.000) arg = 1.0000000000000
       if(arg.lt.-1.000) arg = -1.0000000000000
       a = factor*acos(arg)
       return
       end
c
c---------------------------------------------------------------
       function scalp(p,q,n)
c
c   input: vector p and q of dimension n
c   returns scalar product
c
       dimension p(n), q(n)
       scalp=0.
       do 10 i=1,n
       scalp = scalp + p(i)*q(i)
10     continue
       return
       end
c
c---------------------------------------------------------------
       function vecm(p,n)
c
c   input: vector p of dimension n
c   returns vector magnitude
c
       dimension p(n)
       vecm = sqrt(scalp(p,p,n))
       return
       end

c
c======================================================================

       integer function ij(ix,iy)

c      locates 2-d pixel in 1-d array

       include 'cip2.inc'

       ij = (iy-1)*xdim + ix
       return
       end


c======================================================================

c     subroutine gausz  /  ciba-geigy photochemie ag       semini
c                                       date  26.2.1972
c                                       version 01  modification 00
c        c(n*m)  input:  linearly independent variables
c        d(n)    input:  variables (measured values)
c        x(m)    output: coefficients
c        p(n)    output: fitted variables
c        f(n)    output: errors
c        r(m*m)  internal
c        s(n*m)  internal

      subroutine gausz(r,s,c,x,d,p,f,n,m)

      dimension r(1),s(1),c(1),x(1),d(1),p(1),f(1)
      if(n-m) 4,10,10
    4 llp=6
      write(llp,9)
    9 format(1h ,'*** gausz-error: n<m')
      return

c     orthogonalization after schmidt

   10 z=0.0
      do 20 i=1,n
   20 z=z+c(i)*c(i)
      z=sqrt(z)
      do 30 i=1,n
   30 s(i)=c(i)/z
      r(1)=z
      if (m-2) 45,35,35
   35 do 40 k=2,m
      kk=k-1
      do 50 i=1,kk
      z=0.0
      do 60 l=1,n
      is=n*(i-1)+l
      ic=n*(k-1)+l
   60 z=z+s(is)*c(ic)
      ir=m*(k-1)+i
      r(ir)=z
      ir=m*(i-1)+k
      r(ir)=0.0
   50 continue
      do 70 i=1,n
      ic=n*(k-1)+i
      z=c(ic)
      do 80 l=1,kk
      is=n*(l-1)+i
      ir=m*(k-1)+l
   80 z=z-r(ir)*s(is)
      is=n*(k-1)+i
      s(is)=z
   70 continue
      z=0.0
      do 90 i=1,n
      is=n*(k-1)+i
   90 z=z+s(is)*s(is)
      z=sqrt(z)
      do 100 i=1,n
      is=n*(k-1)+i
  100 s(is)=s(is)/z
      ir=m*(k-1)+k
      r(ir)=z
   40 continue
   45 do 110 k=1,m
      z=0.0
      do 115 i=1,n
      is=n*(k-1)+i
  115 z=z+s(is)*d(i)
      p(k)=z
  110 continue

c     back substitution

      ir=m*(m-1)+m
      x(m)=p(m)/r(ir)
      if(m-2) 140,112,112
  112 mm=m-1
      do 120 k=1,mm
      mk=m-k
      z=p(mk)
      do 130 i=1,k
      mi=mk+i
      ir=m*(mi-1)+mk
  130 z=z-r(ir)*x(mi)
      ir=m*(mk-1)+mk
  120 x(mk)=z/r(ir)
  140 continue
      do 160 j=1,n
      p(j)=0.0
      do 150 k=1,m
      ic=n*(k-1)+j
      p(j)=p(j)+c(ic)*x(k)
  150 continue
      f(j)=p(j)-d(j)
  160 continue
      return
      end
